package BAUM;

import PERIODENSYSTEM.*;
import EINGABE.*;
import java.util.Vector;

//der baum
public class Tree {
    //einstiegspunkt
    private Node root;
    //rckgabevektor
    public Vector ausgang;
    /** konstruktor zum erzeugen des isotopen baums */
    public Tree()
    {
	root = null;
	ausgang = null;
    }
    /**
     *verteilt die isotopen der reihe nach im baum, 
     *hrt auf wenn ein knoten einen prozentwert von unter 0.01 erreicht hat
     *und liefert einen vektor mit den berechneten isotopen zurck
     */
    public Vector mach_ausrechnen(Vector eingang, PerSys per)
    {
	//neuen vektor anlegen
        ausgang = new Vector ();
	//den einstiegspunkt anlegen
        root = new Node ();
	//der einstiegspunkt bekommt 100%
        root.percent = 1;
	//und 0 gewicht
        root.weight = 0;
	//jetzt wird der baum aufgebaut
        rechne(eingang, root, per, 0, 1);
	//und der vektor zurck gegeben
        return ausgang;
    }
    //isotopen berechnen
    //bergeben wird:
    // - eingabevektor
    // - aktueller knoten
    // - das periodensystem
    // - wo wir und im eingabevektor befinden
    // - und beim wievielten isotop wir sind
    private void rechne(Vector eingang, Node root, PerSys per, int wo, int wieviel)
    {
	//wenn der aktuelle knoten weniger als 0.0001% hat, fliegt er raus
        if (root.percent < 0.0001) return;
	//wenn wir beim letzten element im eingabevektor
	//angekommen sind, packen wir den aktuellen wert ind den
	//ausgabevektor und returnen
	if (eingang.size() < (wo + 1))
        {
            einfuegen(root);
            return;
        }
	//wenn noch nich alle isotopen des aktuellen elements betrachtet wurden
	//nehmen wir uns das nchste vor
        if (wieviel <= ((element_object)eingang.elementAt(wo)).anzahl) 
        {
	    //gucken wieviele kinder es gibt
            int kinderanz = per.elemente[((element_object)eingang.elementAt(wo)).ord].isos.laenge();
	    //legen das kinder-array an
            root.kinder = new Node [kinderanz];
	    //und legen die kinder an
            for (int i = 0; i < kinderanz; i++)
                root.kinder[i] = new Node ();
	    //setzen current als anfang der isotopenschlange
            Isotops current = per.elemente[((element_object)eingang.elementAt(wo)).ord].isos.give_head();
	    //und wandern durch die schlange um die kinder zu fllen
            for (int i = 0; i < kinderanz; i++)
            {
		//kinder ihre werte zuweisen
                root.kinder[i].percent = root.percent * current.percent;
                root.kinder[i].weight = root.weight + current.weight;
		//und rekursiv die kinder betrachten
                rechne(eingang, root.kinder[i], per, wo, wieviel + 1);
		//weiter in der schlange wandern
                if (current.next != null) current = current.next;
		//oder raus aus der schleife
                else break;
            }
        }
	//wenn alle isotope betrachtet -> nchstes element auswerten
        else rechne (eingang, root, per, wo + 1, 1);
    }
    
    //einfgen in den ausgabevektor
    //parameter -> aktueller knoten
    private void einfuegen (Node current)
    {
	//gewicht runden
        current.weight = Math.round( current.weight * 1000000.) / 1000000.;
	//wenn vektor leer -> einfach einfgen
        if (ausgang.size() == 0)
        {
            ausgang.add(current);
            return;
        }
	//ansonsten gucken ob element schon besteht, dann prozentzahlen addieren
        for (int i = 0; i < ausgang.size(); i++)
            if ( ((Node)ausgang.elementAt(i)).weight == current.weight)
            {
                ((Node)ausgang.elementAt(i)).percent += current.percent;
                return;
            }
	//ansonsten hinten an den vektor hngen
        ausgang.add(current);
        return;
    }
}
